#ifndef ZMODELER_STRUCT_PROCLIST_H_INCLUDED
#define ZMODELER_STRUCT_PROCLIST_H_INCLUDED

//////////////////////////////////////////////////////////////////////////////
//          List of procedures that might be applied        //
//////////////////////////////////////////////////////////////////////////////

struct tProcs
{
  char*               ProcName;    //procs are reffered by their names
  PLUGPROCESSORPROC   ApplyPre;    //address of procedure to call before event
  PLUGPROCESSORPROC   ApplyPost;    //address of procedure to call after event
  //address of procedure to call right after the proc was added to the list
  PLUGPROCESSORPROC   Add;      
  //address of procedure to call before removing proc from list
  PLUGPROCESSORPROC   Remove;
  //Handle of the plugin where the proc is located. this plugin MUST NOT be Dynamic
  HINSTANCE           Handle;
};

struct tProcsListBlock
{
  tProcs            Procs;
  tProcsListBlock*  Next;
};

typedef tProcsListBlock*  tProcsListItem;

//////////////////////////////////////////////////////////////////////////////
//    Performs processing, can add or remove procs to/from list      //
//////////////////////////////////////////////////////////////////////////////
class DllExport CProcsList
{
public:
//-------------------------
//  data members
  tProcsListItem  Head;  //head of the list
  
//-------------------------
//  construction/deconstruction
  CProcsList();  //initializates the empty list
  //empties the list (and calls Remove(params) proc for
  //each entry in the list
  ~CProcsList();

//-------------------------
//  functions

  //Adds entry to the list. The entries are reffered by names,
  //so the name should be unique.
  DWORD  AddProc(char*      Name,
          PLUGPROCESSORPROC APre,
          PLUGPROCESSORPROC APost,
          PLUGPROCESSORPROC OnAdd,
          PLUGPROCESSORPROC OnRemove,
          tProcParams*      params,
          HINSTANCE         handle);
  //Removes the proc, reffered by Name.
  DWORD  RemoveProc(char* Name, tProcParams* params);
  //Performs ApplyPre in all entries (where applied).
  //Returns combination of Z3D_PLUGRESULT_ flags.
  DWORD  ProcessPre(tProcParams*    params);
  //Performs ApplyPost in all entries (where applied).
  //Returns combination of Z3D_PLUGRESULT_ flags.
  DWORD  ProcessPost(tProcParams*  params);
  //Empties the list.
  //Returns combination of Z3D_PLUGRESULT_ flags.
  DWORD  UnloadList(tProcParams*    params);

};//CProcsList


#endif

